/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.LocalAlternativeGroup;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.MathUtils;
import cz.insophy.inplan.util.Triple;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Action
implements Propertized {
    public static final String DEFAULT_LOCAL_ALT = "*";
    private final Bom bom;
    private final String name;
    private final String description;
    private final double qtyCoef;
    private final Product product;
    private final String capabilityReq;
    private final long minTimeToPrepare;
    private final long maxTimeToPrepare;
    private final double transferBatch;
    private final List<MaterialQuantity> produces;
    private final ArrayList<MaterialQuantity> producesMod;
    private List<Triple<String, Double, Double>> producesNames;
    final long productionTime;
    private final Divisibility divisibility;
    private final double granularity;
    private final String rebuildType;
    private final boolean joinedWithFollowing;
    private LocalAlternativeGroup lag;
    private String localAltName;
    private final PropertySupport propertySupport;
    public static final long NO_MAX_TIME_TO_PREPARE = -1L;

    protected Action(Builder bob) {
        this.name = bob.name;
        this.description = Strings.nullToEmpty(bob.description);
        this.product = bob.product;
        this.qtyCoef = bob.qtyCoef;
        this.bom = bob.bom == null ? new Bom(Collections.emptyList()) : bob.bom;
        if (bob.productionTime <= 0L) {
            throw new IllegalArgumentException("productionTime has to be > 0");
        }
        this.productionTime = bob.productionTime;
        Preconditions.checkNotNull(bob.rebuildType, "rebuildType cannot be null.");
        this.rebuildType = bob.rebuildType;
        this.capabilityReq = bob.capabilityReq;
        this.minTimeToPrepare = bob.minTimeToPrepare;
        this.maxTimeToPrepare = bob.maxTimeToPrepare;
        this.transferBatch = bob.transferBatch;
        if (bob.producesNames == null) {
            throw new NullPointerException("The list of action products must not be null.");
        }
        this.producesNames = bob.producesNames;
        this.producesMod = new ArrayList();
        this.produces = Collections.unmodifiableList(this.producesMod);
        if (bob.granularity < 0.0) {
            throw new IllegalArgumentException("Action granularity must be >= 0.");
        }
        if (bob.granularity > 0.0 && this.timeToMake(bob.granularity) == 0L) {
            bob.granularity = 1.0 / (double)this.productionTime;
        }
        this.granularity = bob.granularity;
        this.divisibility = bob.divisibility;
        this.joinedWithFollowing = bob.joinedWithFollowing;
        this.lag = null;
        this.localAltName = bob.localAltName;
        this.propertySupport = new PropertySupport();
    }

    public Bom getBom() {
        return this.bom;
    }

    public long getProductionTime() {
        return this.productionTime;
    }

    public double getGranularity() {
        return this.granularity;
    }

    public String getRebuildType() {
        return this.rebuildType;
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public Product getProduct() {
        return this.product;
    }

    public double getQtyCoef() {
        return this.qtyCoef;
    }

    public long timeToMake(double q) {
        double doubleTime;
        Preconditions.checkArgument(q > -1.0E-7, "The qty must be greater than or equal to 0.");
        if (q < 0.0) {
            q = 0.0;
        }
        long timeConsumption = Comparators.equals(doubleTime = q * (double)this.productionTime, Math.floor(doubleTime), 1.0E-7) ? Math.round(doubleTime) : Math.round(Math.ceil(doubleTime));
        return timeConsumption;
    }

    public long normtime(double q) {
        return this.timeToMake(q);
    }

    public String getCapabilityReq() {
        return this.capabilityReq;
    }

    public double canBeMade(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time has to be >= 0");
        }
        if (time == 0L) {
            return 0.0;
        }
        double qty = (double)time / (double)this.productionTime;
        if ((qty = this.roundQtyWrtGranularityDown(qty)) <= 9.223372036854776E18 && qty >= -9.223372036854776E18) {
            return qty;
        }
        throw new IllegalArgumentException("Time too large.");
    }

    public double roundQtyWrtGranularityDown(double qty) {
        return MathUtils.roundQtyWrtGranularityDown(qty, this.granularity);
    }

    public double roundQtyWrtGranularityUp(double qty) {
        return MathUtils.roundQtyWrtGranularityUp(qty, this.granularity);
    }

    public double computeRequestedQty(double requestedQty) {
        return requestedQty * this.getQtyCoef();
    }

    public long getMinTimeToPrepare() {
        return this.minTimeToPrepare;
    }

    public long getMaxTimeToPrepare() {
        return this.maxTimeToPrepare;
    }

    public double getTransferBatch() {
        return this.transferBatch;
    }

    public long getTransferBatchTime() {
        return this.timeToMake(this.transferBatch);
    }

    public boolean isJoinedWithFollowing() {
        return this.joinedWithFollowing;
    }

    public List<MaterialQuantity> getProduces() {
        return this.produces;
    }

    public List<Problem> resolveProducibles(Map<String, ? extends Material> matprods) {
        if (this.producesNames == null) {
            throw new IllegalStateException("Action.resolveProducibles must be called only once.");
        }
        if (this.producesNames.isEmpty() && !this.hasLocalAlts()) {
            return Collections.emptyList();
        }
        LinkedList<Problem> problems = Lists.newLinkedList();
        for (Triple<String, Double, Double> pn : this.producesNames) {
            Material material = matprods.get(pn.getFirst());
            if (material == null) {
                Problem problem = Problem.createProblem2("04100", this, this.getProduct(), pn.getFirst());
                problems.add(problem);
                continue;
            }
            MaterialQuantity prodItem = new MaterialQuantity(material, pn.getSecond(), pn.getThird());
            this.producesMod.add(prodItem);
        }
        this.producesNames = null;
        if (this.hasLocalAlts() && this.isMainLocalAlt()) {
            for (Action alt : Iterables.skip(this.getLocalAlts(), 1)) {
                problems.addAll(alt.resolveProducibles(matprods));
            }
        }
        return Collections.unmodifiableList(problems);
    }

    List<Triple<String, Double, Double>> getProducesNames() {
        return this.producesNames;
    }

    void makeMemberOfLag(LocalAlternativeGroup lag) {
        Preconditions.checkState(this.lag == null, "LocalAlternativeGroup can be set only once");
        this.lag = lag;
    }

    public String getLocalAltName() {
        return this.localAltName;
    }

    public boolean isMainLocalAlt() {
        return this.lag == null || this.lag.getActions().get(0) == this;
    }

    public Action getMainLocalAlt() {
        return this.lag == null ? this : this.lag.getActions().get(0);
    }

    public Iterable<Action> getLocalAlts() {
        return this.lag == null ? Collections.singleton(this) : this.lag;
    }

    public boolean hasLocalAlts() {
        return this.lag != null && this.lag.getActions().size() > 1;
    }

    public Action getLocalAlt(String localAltName) {
        Action res;
        block2: {
            block1: {
                res = null;
                if (this.lag != null) break block1;
                if (!this.localAltName.equals(localAltName)) break block2;
                res = this;
                break block2;
            }
            for (Action alt : this.lag) {
                if (!alt.localAltName.equals(localAltName)) continue;
                res = alt;
                break;
            }
        }
        return res;
    }

    public String toString() {
        return String.format("%s(%s, prod=%s)", this.getClass().getName(), this.getName(), this.getProduct());
    }

    @Nonnull
    public Divisibility getDivisibility() {
        return this.divisibility;
    }

    @Deprecated
    public long getRebuildTime() {
        return 0L;
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }

    @Override
    @Nonnull
    public String getId() {
        throw new UnsupportedOperationException("Actions do not have unique ids (yet).");
    }

    public static class Builder {
        private Bom bom;
        private String name;
        private String description;
        private Product product;
        private double qtyCoef = 1.0;
        private String capabilityReq;
        private long minTimeToPrepare;
        private long maxTimeToPrepare;
        private double transferBatch;
        private List<Triple<String, Double, Double>> producesNames;
        private long productionTime;
        private double granularity = 1.0;
        private Divisibility divisibility = Divisibility.DIVISIBLE;
        private String rebuildType;
        boolean joinedWithFollowing;
        private String localAltName = "*";

        public Builder() {
        }

        public Builder(Action action) {
            this.setBom(action.bom);
            this.setCapabilityReq(action.capabilityReq);
            this.setGranularity(action.granularity);
            this.setMaxTimeToPrepare(action.maxTimeToPrepare);
            this.setMinTimeToPrepare(action.minTimeToPrepare);
            this.setTransferBatch(action.transferBatch);
            this.setName(action.name);
            this.setDescription(action.description);
            ArrayList<Triple<String, Double, Double>> producesNames = Lists.newArrayList();
            for (MaterialQuantity pi : action.producesMod) {
                producesNames.add(new Triple<String, Double, Double>(pi.getMaterial().getName(), pi.getQty(), pi.getBatch()));
            }
            this.setProducesNames(producesNames);
            this.setProduct(action.product);
            this.setProductionTime(action.productionTime);
            this.setRebuildType(action.rebuildType);
            this.setLocalAltName(action.localAltName);
            this.setJoinedWithFollowing(action.joinedWithFollowing);
            this.setDivisibility(action.divisibility);
        }

        public void setBom(Bom bom) {
            this.bom = bom;
        }

        public void setRebuildType(String type) {
            this.rebuildType = type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setProduct(Product product) {
            this.product = product;
        }

        public void setQtyCoef(double qtyCoef) {
            this.qtyCoef = qtyCoef;
        }

        public void setCapabilityReq(String capabilityReq) {
            this.capabilityReq = capabilityReq;
        }

        public void setMinTimeToPrepare(long minTimeToPrepare) {
            this.minTimeToPrepare = minTimeToPrepare;
        }

        public void setMaxTimeToPrepare(long maxTimeToPrepare) {
            this.maxTimeToPrepare = maxTimeToPrepare;
        }

        public void setTransferBatch(double transferBatch) {
            this.transferBatch = transferBatch;
        }

        public void setProducesNames(List<Triple<String, Double, Double>> producesNames) {
            this.producesNames = producesNames;
        }

        public void setProductionTime(long productionTime) {
            this.productionTime = productionTime;
        }

        public void setGranularity(double granularity) {
            this.granularity = granularity;
        }

        public void setJoinedWithFollowing(boolean joinWithFollowing) {
            this.joinedWithFollowing = joinWithFollowing;
        }

        public void setLocalAltName(String localAltName) {
            this.localAltName = localAltName;
        }

        public void setDivisibility(Divisibility divisibility) {
            this.divisibility = divisibility;
        }

        public boolean isValid() {
            return (this.maxTimeToPrepare >= 0L || this.maxTimeToPrepare == -1L) && this.minTimeToPrepare >= 0L && this.name != null && this.producesNames != null && this.product != null && this.productionTime > 0L && this.rebuildType != null && this.granularity >= 0.0 && this.divisibility != null;
        }

        public void reset() {
            this.setBom(null);
            this.setCapabilityReq(null);
            this.setMaxTimeToPrepare(0L);
            this.setMinTimeToPrepare(0L);
            this.setTransferBatch(-1.0);
            this.setName(null);
            this.setDescription(null);
            this.setProducesNames(null);
            this.setProduct(null);
            this.setProductionTime(0L);
            this.setRebuildType(null);
            this.setGranularity(1.0);
            this.setJoinedWithFollowing(false);
            this.setLocalAltName(Action.DEFAULT_LOCAL_ALT);
        }

        public Action build() {
            Preconditions.checkState(this.isValid(), "Cannot build action. Properties of the action are not valid.");
            return new Action(this);
        }
    }

    public static enum Divisibility {
        INDIVISIBLE,
        DIVISIBLE;

    }
}

